<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class CampaignContext extends InstanceContext {
    /**
     * Initialize the CampaignContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sid The SID that identifies the resource to fetch
     */
    public function __construct(Version $version, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['sid' => $sid, ];

        $this->uri = '/a2p/Campaigns/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch the CampaignInstance
     *
     * @return CampaignInstance Fetched CampaignInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): CampaignInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new CampaignInstance($this->version, $payload, $this->solution['sid']);
    }

    /**
     * Delete the CampaignInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Messaging.V1.CampaignContext ' . \implode(' ', $context) . ']';
    }
}