

<?php $__env->startSection('panel_content'); ?>
    <div class="aiz-titlebar mt-2 mb-4">
        <div class="h6">
            <span><?php echo e(translate('Conversations With ')); ?></span>
            <?php if($conversation->sender_id == Auth::user()->id && $conversation->receiver->shop != null): ?>
                <a href="<?php echo e(route('shop.visit', $conversation->receiver->shop->slug)); ?>" class=""><?php echo e($conversation->receiver->shop->name); ?></a>
            <?php endif; ?>
        </div>
    </div>
    <div class="card">
        <div class="card-header">
            <h5 class="card-title fs-16 fw-600 mb-0">#<?php echo e($conversation->title); ?>

            (
                <?php echo e(translate('Between you and')); ?>

                <?php if($conversation->sender_id == Auth::user()->id): ?>
                    <?php echo e($conversation->receiver->name); ?>

                <?php else: ?>
                    <?php echo e($conversation->sender->name); ?>

                <?php endif; ?>
            )
            </h5>
        </div>

        <div class="card-body">
            <ul class="list-group list-group-flush">
                
                <div class="row">
                    <div class="col-md-8">
                <?php $__currentLoopData = $conversation->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item">
                        <div class="media mb-2">
                          <img class="avatar avatar-xs mr-3" <?php if($message->user != null): ?> src="<?php echo e(uploaded_asset($message->user->avatar_original)); ?>" <?php endif; ?> onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/avatar-place.png')); ?>';">
                          <div class="media-body">
                            <h6 class="mb-0 fw-600">
                                <?php if($message->user != null): ?>
                                    <?php echo e($message->user->name); ?>

                                <?php endif; ?>
                            </h6>
                            <p class="opacity-50"><?php echo e($message->created_at); ?></p>
                          </div>
                        </div>
                        <p>
                            <?php echo e($message->message); ?>

                        </p>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                    <div class="col-md-4">
                      <?php if($conversation->product_ids != NULL): ?>
                        <p class="fw-600">
                          Company : <?php echo e($conversation->company_name ?? 'ABC'); ?>

                        </p>
                        <p class="fw-600">
                          Telephone : <?php echo e($conversation->telephone ?? '0442123131232'); ?>

                        </p>
                            <?php $__currentLoopData = json_decode($conversation->product_ids); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            
                                <?php
                                
                                    $product = \App\Product::find($prod);
                                    $quantity = json_decode($conversation->quantity);
                                
                                ?>
                                
                                <?php if($product != null): ?>
                                <div class="d-flex mt-3">
                                    <span class="mr-2 ml-0">
                                        <img
                                            src="<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>"
                                            data-src="<?php echo e(uploaded_asset($product->thumbnail_img)); ?>"
                                            class="img-fit lazyload size-60px rounded"
                                            alt="<?php echo e($product->getTranslation('name')); ?>"
                                            onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';"
                                        >
                                    </span>
                                    <div class="flex-column">
                                        <span class="fs-14 opacity-60"><?php echo e($product->name); ?></span>
                                        <p class="fs-14 fw-600"><span class="fs-14 opacity-60">Quantity : </span><?php echo e($quantity[$key]); ?></p>    
                                    </div>
                                    
                                </div>
                                <?php else: ?>
                                <div class="flex-column">
                                        <span class="fs-14 opacity-60">Product Data is not Available.</span>  
                                </div>
                                <?php endif; ?>
                                
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>  
                    </div>
                </div>
            </ul>
            <form class="pt-4" action="<?php echo e(route('messages.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="conversation_id" value="<?php echo e($conversation->id); ?>">
                <div class="form-group">
                    <textarea class="form-control" rows="4" name="message" placeholder="<?php echo e(translate('Type your reply')); ?>" required></textarea>
                </div>
                <div class="form-group mb-0 text-right">
                    <button type="submit" class="btn btn-primary"><?php echo e(translate('Send')); ?></button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
    function refresh_messages(){
        $.post('<?php echo e(route('conversations.refresh')); ?>', {_token:'<?php echo e(@csrf_token()); ?>', id:'<?php echo e(encrypt($conversation->id)); ?>'}, function(data){
            $('#messages').html(data);
        })
    }

    refresh_messages(); // This will run on page load
    setInterval(function(){
        refresh_messages() // this will run after every 5 seconds
    }, 4000);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.user_panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/haseeb40/public_html/resources/views/frontend/user/conversations/show.blade.php ENDPATH**/ ?>