

<?php $__env->startSection('content'); ?>
<div class="aiz-titlebar text-left mt-2 mb-3">
	<div class=" align-items-center">
       <h1 class="h3"><?php echo e(translate('Seller Based Selling Report')); ?></h1>
	</div>
</div>

<div class="row">
    <div class="col-md-8 mx-auto">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('seller_sale_report.index')); ?>" method="GET">
                    <div class="form-group row offset-lg-2">
                        <label class="col-md-3 col-form-label"><?php echo e(translate('Sort by verificarion status')); ?> :</label>
                        <div class="col-md-5">
                            <select class="from-control aiz-selectpicker" name="verification_status" required>
                               <option value="1" <?php if($sort_by == '1'): ?> selected <?php endif; ?>><?php echo e(translate('Approved')); ?></option>
                               <option value="0" <?php if($sort_by == '0'): ?> selected <?php endif; ?>><?php echo e(translate('Non Approved')); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-primary" type="submit"><?php echo e(translate('Filter')); ?></button>
                        </div>
                    </div>
                </form>

                <table class="table table-bordered aiz-table mb-0">
                    <thead>
                        <tr>
                            <th><?php echo e(translate('Seller Name')); ?></th>
                            <th data-breakpoints="lg"><?php echo e(translate('Shop Name')); ?></th>
                            <th data-breakpoints="lg"><?php echo e(translate('Number of Product Sale')); ?></th>
                            <th><?php echo e(translate('Order Amount')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $sellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($seller->user != null): ?>
                                <tr>
                                    <td><?php echo e($seller->user->name); ?></td>
                                    <?php if($seller->user->shop != null): ?>
                                        <td><?php echo e($seller->user->shop->name); ?></td>
                                    <?php else: ?>
                                        <td>--</td>
                                    <?php endif; ?>
                                    <td>
                                        <?php
                                            $num_of_sale = 0;
                                            foreach ($seller->user->products as $key => $product) {
                                                $num_of_sale += $product->num_of_sale;
                                            }
                                        ?>
                                        <?php echo e($num_of_sale); ?>

                                    </td>
                                    <td>
                                        <?php echo e(single_price(\App\OrderDetail::where('seller_id', $seller->user->id)->sum('price'))); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="aiz-pagination mt-4">
                    <?php echo e($sellers->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/haseeb40/public_html/resources/views/backend/reports/seller_sale_report.blade.php ENDPATH**/ ?>