

<?php $__env->startSection('panel_content'); ?>
    <div class="aiz-titlebar mt-2 mb-4">
      <div class="row align-items-center">
          <div class="col-md-6">
              <b class="h4"><?php echo e(translate('Conversations')); ?></b>
          </div>
      </div>
    </div>

    <div class="card">
      <div class="card-body">
        <ul class="list-group list-group-flush">
          <?php $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php if($conversation->receiver != null && $conversation->sender != null): ?>
                    <li class="list-group-item px-0">
                      <div class="row gutters-10">
                          <div class="col-auto">
                              <div class="media">
                                  <span class="avatar avatar-sm flex-shrink-0">
                                    <?php if(Auth::user()->id == $conversation->sender_id): ?>
                                        <img <?php if($conversation->receiver->avatar_original == null): ?> src="<?php echo e(static_asset('assets/img/avatar-place.png')); ?>" <?php else: ?> src="<?php echo e(uploaded_asset($conversation->receiver->avatar_original)); ?>" <?php endif; ?> onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/avatar-place.png')); ?>';">
                                    <?php else: ?>
                                        <img <?php if($conversation->sender->avatar_original == null): ?> src="<?php echo e(static_asset('assets/img/avatar-place.png')); ?>" <?php else: ?> src="<?php echo e(uploaded_asset($conversation->sender->avatar_original)); ?>" <?php endif; ?> class="rounded-circle" onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/avatar-place.png')); ?>';">
                                    <?php endif; ?>
                                </span>
                              </div>
                          </div>
                          <div class="col-auto col-lg-3">
                              <p>
                                  <?php if(Auth::user()->id == $conversation->sender_id): ?>
                                      <span class="fw-600"><?php echo e($conversation->receiver->name); ?></span>
                                  <?php else: ?>
                                      <span class="fw-600"><?php echo e($conversation->sender->name); ?></span>
                                  <?php endif; ?>
                                  <br>
                                  <span class="opacity-50">
                                      <?php echo e(date('h:i:m d-m-Y', strtotime($conversation->messages->last()->created_at))); ?>

                                  </span>
                              </p>
                              <p class="fw-600">
                                  Company : <?php echo e($conversation->company_name ?? 'ABC'); ?>

                              </p>
                              <p class="fw-600">
                                  Telephone : <?php echo e($conversation->telephone ?? '0442123131232'); ?>

                              </p>
                          </div>
                          <div class="col-12 col-lg">
                              <div class="block-body">
                                  <div class="block-body-inner pb-3">
                                      <div class="row no-gutters">
                                          <div class="col">
                                              <h6 class="mt-0">
                                                  <a href="<?php echo e(route('conversations.show', encrypt($conversation->id))); ?>" class="fw-600">
                                                      <?php echo e($conversation->title); ?>

                                                  </a>
                                                  <?php if((Auth::user()->id == $conversation->sender_id && $conversation->sender_viewed == 0) || (Auth::user()->id == $conversation->receiver_id && $conversation->receiver_viewed == 0)): ?>
                                                      <span class="badge badge-inline badge-danger"><?php echo e(translate('New')); ?></span>
                                                  <?php endif; ?>
                                              </h6>
                                          </div>
                                      </div>
                                      <p class="mb-0 opacity-50">
                                          <?php echo e($conversation->messages->last()->message); ?>

                                      </p>
                                      <?php if($conversation->product_ids != NULL): ?>
                                          <?php $__currentLoopData = json_decode($conversation->product_ids); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            
                                            <?php
                                            
                                                $product = \App\Product::find($prod);
                                                $quantity = json_decode($conversation->quantity);
                                            
                                            ?>
                                            <?php if($product != null): ?>
                                            <div class="d-flex mt-3">
                                                <span class="mr-2 ml-0">
                                                    <img
                                                        src="<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>"
                                                        data-src="<?php echo e(uploaded_asset($product->thumbnail_img)); ?>"
                                                        class="img-fit lazyload size-60px rounded"
                                                        alt="<?php echo e($product->getTranslation('name')); ?>"
                                                        onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';"
                                                    >
                                                </span>
                                                <div class="flex-column">
                                                    <span class="fs-14 opacity-60"><?php echo e($product->name); ?></span>
                                                    <p class="fs-14 fw-600"><span class="fs-14 opacity-60">Quantity : </span><?php echo e($quantity[$key]); ?></p>    
                                                </div>
                                                
                                            </div>
                                            <?php endif; ?>
                                            
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      <?php endif; ?>
                                  </div>
                              </div>
                          </div>
                      </div>
                    </li>
              <?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
      </div>
    </div>
    <div class="aiz-pagination">
      	<?php echo e($conversations->links()); ?>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.user_panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/haseeb40/public_html/resources/views/frontend/user/conversations/index.blade.php ENDPATH**/ ?>