@extends('frontend.layouts.user_panel')

@section('panel_content')
    <div class="aiz-titlebar mt-2 mb-4">
        <div class="h6">
            <span>{{ translate('Conversations With ')}}</span>
            @if ($conversation->sender_id == Auth::user()->id && $conversation->receiver->shop != null)
                <a href="{{ route('shop.visit', $conversation->receiver->shop->slug) }}" class="">{{ $conversation->receiver->shop->name }}</a>
            @endif
        </div>
    </div>
    <div class="card">
        <div class="card-header">
            <h5 class="card-title fs-16 fw-600 mb-0">#{{ $conversation->title }}
            (
                {{ translate('Between you and') }}
                @if ($conversation->sender_id == Auth::user()->id)
                    {{ $conversation->receiver->name }}
                @else
                    {{ $conversation->sender->name }}
                @endif
            )
            </h5>
        </div>

        <div class="card-body">
            <ul class="list-group list-group-flush">
                
                <div class="row">
                    <div class="col-md-8">
                @foreach($conversation->messages as $message)
                    <li class="list-group-item">
                        <div class="media mb-2">
                          <img class="avatar avatar-xs mr-3" @if($message->user != null) src="{{ uploaded_asset($message->user->avatar_original) }}" @endif onerror="this.onerror=null;this.src='{{ static_asset('assets/img/avatar-place.png') }}';">
                          <div class="media-body">
                            <h6 class="mb-0 fw-600">
                                @if ($message->user != null)
                                    {{ $message->user->name }}
                                @endif
                            </h6>
                            <p class="opacity-50">{{$message->created_at}}</p>
                          </div>
                        </div>
                        <p>
                            {{ $message->message }}
                        </p>
                    </li>
                @endforeach
                </div>
                    <div class="col-md-4">
                      @if($conversation->product_ids != NULL)
                        <p class="fw-600">
                          Company : {{ $conversation->company_name ?? 'ABC' }}
                        </p>
                        <p class="fw-600">
                          Telephone : {{ $conversation->telephone ?? '0442123131232'}}
                        </p>
                            @foreach(json_decode($conversation->product_ids) as $key => $prod)
                                            
                                @php
                                
                                    $product = \App\Product::find($prod);
                                    $quantity = json_decode($conversation->quantity);
                                
                                @endphp
                                
                                @if($product != null)
                                <div class="d-flex mt-3">
                                    <span class="mr-2 ml-0">
                                        <img
                                            src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                            data-src="{{ uploaded_asset($product->thumbnail_img) }}"
                                            class="img-fit lazyload size-60px rounded"
                                            alt="{{ $product->getTranslation('name')  }}"
                                            onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';"
                                        >
                                    </span>
                                    <div class="flex-column">
                                        <span class="fs-14 opacity-60">{{ $product->name }}</span>
                                        <p class="fs-14 fw-600"><span class="fs-14 opacity-60">Quantity : </span>{{ $quantity[$key] }}</p>    
                                    </div>
                                    
                                </div>
                                @else
                                <div class="flex-column">
                                        <span class="fs-14 opacity-60">Product Data is not Available.</span>  
                                </div>
                                @endif
                                
                            @endforeach
                        @endif  
                    </div>
                </div>
            </ul>
            <form class="pt-4" action="{{ route('messages.store') }}" method="POST">
                @csrf
                <input type="hidden" name="conversation_id" value="{{ $conversation->id }}">
                <div class="form-group">
                    <textarea class="form-control" rows="4" name="message" placeholder="{{ translate('Type your reply') }}" required></textarea>
                </div>
                <div class="form-group mb-0 text-right">
                    <button type="submit" class="btn btn-primary">{{ translate('Send') }}</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
    function refresh_messages(){
        $.post('{{ route('conversations.refresh') }}', {_token:'{{ @csrf_token() }}', id:'{{ encrypt($conversation->id) }}'}, function(data){
            $('#messages').html(data);
        })
    }

    refresh_messages(); // This will run on page load
    setInterval(function(){
        refresh_messages() // this will run after every 5 seconds
    }, 4000);
    </script>
@endsection
