

<?php $__env->startSection('content'); ?>

<div class="aiz-titlebar text-left mt-2 mb-3">
    <div class="align-items-center">
        <h1 class="h3"><?php echo e(translate('All Notifications')); ?></h1>
    </div>
</div>

<?php if(get_setting('conversation_system') == 1): ?>
    <?php
        $conversations = \App\Conversation::where('receiver_id', Auth::user()->id)->orderBy('id', 'desc')->get();
    ?>
<?php endif; ?>

<div class="row">
    <div class="col-md-8 mx-auto">
        <div class="card">
            <form class="" id="sort_customers" action="" method="GET">
                <div class="card-header row gutters-5">
                    <div class="col">
                        <h5 class="mb-0 h6"><?php echo e(translate('Notifications')); ?></h5>
                    </div>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        
                        <?php $__empty_1 = true; $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <li class="list-group-item d-flex justify-content-between align-items- py-3">
                                <div class="media text-inherit">
                                    <div class="media-body">
                                        
                                            <p class="mb-1 text-truncate-2">
                                                <a href="<?php echo e(route('conversations.admin_show', encrypt($conversation->id))); ?>" title="<?php echo e(translate('View')); ?>"><?php echo e($conversation->title); ?></a>
                                            </p>
                                            <small class="text-muted">
                                                <?php echo e(date("F j Y, g:i a", strtotime($conversation->created_at))); ?>

                                            </small>
                                        
                                    </div>
                                </div>
                                <?php if($conversation->receiver_viewed == 0): ?>
                                <div>
                                    <span class="badge badge-inline badge-danger">unread</span>
                                </div>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <li class="list-group-item">
                                <div class="py-4 text-center fs-16">
                                    <?php echo e(translate('No notification found')); ?>

                                </div>
                            </li>
                        <?php endif; ?>
                        
                        <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php if($notification->type == 'App\Notifications\OrderNotification'): ?>
                                <li class="list-group-item d-flex justify-content-between align-items- py-3">
                                    <div class="media text-inherit">
                                        <div class="media-body">
                                            <p class="mb-1 text-truncate-2">
                                                <?php echo e(translate('Order code: ')); ?>

                                                <a href="<?php echo e(route('all_orders.show', encrypt($notification->data['order_id']))); ?>">
                                                    <?php echo e($notification->data['order_code']); ?>

                                                </a>
                                                <?php echo e(translate(' has been '. ucfirst(str_replace('_', ' ', $notification->data['status'])))); ?>

                                            </p>
                                            <small class="text-muted">
                                                <?php echo e(date("F j Y, g:i a", strtotime($notification->created_at))); ?>

                                            </small>
                                        </div>
                                    </div>
                                </li>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php if(count($notifications) == 0 && count($conversations) == 0): ?>
                            <li class="list-group-item">
                                <div class="py-4 text-center fs-16">
                                    <?php echo e(translate('No notification found')); ?>

                                </div>
                            </li>
                            <?php endif; ?>
                        <?php endif; ?>
                        
                    </ul>
                    
                    <?php echo e($notifications->links()); ?>

                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/haseeb40/public_html/resources/views/backend/notification/index.blade.php ENDPATH**/ ?>