@extends('frontend.layouts.user_panel')

@section('panel_content')
    <div class="aiz-titlebar mt-2 mb-4">
      <div class="row align-items-center">
          <div class="col-md-6">
              <b class="h4">{{ translate('Conversations')}}</b>
          </div>
      </div>
    </div>

    <div class="card">
      <div class="card-body">
        <ul class="list-group list-group-flush">
          @foreach ($conversations as $key => $conversation)
              
                    <li class="list-group-item px-0">
                      <div class="row gutters-10">
                          <div class="col-auto">
                              <div class="media">
                                  <span class="avatar avatar-sm flex-shrink-0">
                                        <img src="{{ static_asset('assets/img/avatar-place.png') }}">
                                </span>
                              </div>
                          </div>
                          <div class="col-auto col-lg-3">
                              <p>
                                  
                                      <span class="fw-600">{{ Auth::user()->name }}</span>
                                  
                                  <br>
                                  <span class="opacity-50">
                                      {{ date('h:i:m d-m-Y', strtotime($conversation->created_at)) }}
                                  </span>
                              </p>
                              
                              <p class="fw-600">
                                  Company : {{ $conversation->company_name }}
                              </p>
                              <p class="fw-600">
                                  Telephone : {{ $conversation->telephone }}
                              </p>
                          </div>
                          <div class="col-12 col-lg">
                              <div class="block-body">
                                  <div class="block-body-inner pb-3">
                                      <div class="row no-gutters">
                                          <div class="col">
                                              <h6 class="mt-0">
                                                  <a href="{{ route('inquiry.show', encrypt($conversation->id)) }}" class="text-dark fw-600">
                                                      {{  \Illuminate\Support\Str::limit($conversation->message, 10, ' ...') }}
                                                  </a>
                                              </h6>
                                          </div>
                                      </div>
                                      <p class="mb-0 opacity-50">
                                          {{ $conversation->message }}
                                      </p>
                                      @foreach(json_decode($conversation->product_ids) as $key => $prod)
                                        
                                        @php
                                        
                                            $product = \App\Product::find($prod);
                                            $quantity = json_decode($conversation->quantity);
                                        
                                        @endphp
                                        
                                        <div class="d-flex mt-3">
                                            <span class="mr-2 ml-0">
                                                <img
                                                    src="{{ uploaded_asset($product->thumbnail_img) }}"
                                                    class="img-fit size-60px rounded"
                                                    alt="{{ $product->getTranslation('name')  }}"
                                                >
                                            </span>
                                            <div class="flex-column">
                                                <span class="fs-14 opacity-60">{{ $product->name }}</span>
                                                <p class="fs-14 fw-600"><span class="fs-14 opacity-60">Quantity : </span>{{ $quantity[$key] }}</p>    
                                            </div>
                                            
                                        </div>
                                        
                                        
                                      @endforeach
                                  </div>
                              </div>
                          </div>
                      </div>
                    </li>
              
          @endforeach
      </ul>
      </div>
    </div>
    <div class="aiz-pagination">
      	{{ $conversations->links() }}
    </div>

@endsection
