@extends('backend.layouts.app')

@section('content')

<div class="col-lg-12">
    <div class="card">
        <div class="card-header">
            <h5 class="card-title">#{{ $conversation->title }} (Between @if($conversation->sender != null) {{ $conversation->sender->name }} @endif and @if($conversation->receiver != null) {{ $conversation->receiver->name }} @endif)
            </h5>
        </div>

        <div class="card-body">
            <ul class="list-group list-group-flush">
                <div class="row">
                    <div class="col-md-8">
                     
                @foreach($conversation->messages as $message)
                    <li class="list-group-item">
                        <div class="media mb-2">
                          <img class="avatar avatar-xs mr-3" @if($message->user != null) src="{{ uploaded_asset($message->user->avatar_original) }}" @endif onerror="this.onerror=null;this.src='{{ static_asset('assets/img/avatar-place.png') }}';">
                          <div class="media-body">
                            <h6 class="mb-0 fw-600">
                                @if ($message->user != null)
                                    {{ $message->user->name }}
                                @endif
                            </h6>
                            <p class="opacity-50">{{$message->created_at}}</p>
                          </div>
                        </div>
                        <p>
                            {{ $message->message }}
                        </p>                
                    </li>
                @endforeach
                   
                    </div>
                    <div class="col-md-4">
                      @if($conversation->product_ids != NULL)
                        <p class="fw-600">
                          Company : {{ $conversation->company_name ?? 'ABC' }}
                        </p>
                        <p class="fw-600">
                          Telephone : {{ $conversation->telephone ?? '0442123131232'}}
                        </p>
                            @foreach(json_decode($conversation->product_ids) as $key => $prod)
                                            
                                @php
                                
                                    $product = \App\Product::find($prod);
                                    $quantity = json_decode($conversation->quantity);
                                
                                @endphp
                                
                                <div class="d-flex mt-3">
                                    <span class="mr-2 ml-0">
                                        <img
                                            src="{{ uploaded_asset($product->thumbnail_img) }}"
                                            class="img-fit size-60px rounded"
                                            alt="{{ $product->getTranslation('name')  }}"
                                        >
                                    </span>
                                    <div class="flex-column">
                                        <span class="fs-14 opacity-60">{{ $product->name }}</span>
                                        <p class="fs-14 fw-600"><span class="fs-14 opacity-60">Quantity : </span>{{ $quantity[$key] }}</p>    
                                    </div>
                                    
                                </div>
                                
                            @endforeach
                        @endif  
                    </div>
                </div>
            </ul>
            @if (Auth::user()->id == $conversation->receiver_id)
                <form action="{{ route('messages.store') }}" method="POST">
                    @csrf
                    <input type="hidden" name="conversation_id" value="{{ $conversation->id }}">
                    <div class="row">
                        <div class="col-md-12">
                            <textarea class="form-control" rows="4" name="message" placeholder="{{ translate('Type your reply') }}" required></textarea>
                        </div>
                    </div>
                    <br>
                    <div class="text-right">
                        <button type="submit" class="btn btn-info">{{translate('Send')}}</button>
                    </div>
                </form>
            @endif
        </div>
    </div>
</div>

@endsection
